import os
import json
class ExperienceLogger:
    def __init__(self,
                 output_dir="outputs",
                 filename="log.json"):
        self.filename = filename
        self.output_dir = output_dir
        if not os.path.exists(output_dir):
            os.makedirs(output_dir)
        self.log_file = os.path.join(output_dir, filename)

    def log(self, trajectory):
        trajectory = {'trajectory': trajectory}
        with open(self.log_file, "w") as f:
            json.dump(trajectory, f)
